package org.eclipse.jem.tests.beaninfo;
/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;


public class TestBoundSuper extends TestBoundNotBound {
	
	private boolean boundProperty;
	
	protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

	public void setBoundProperty(boolean boundProperty) {
		boolean old = this.boundProperty;
		this.boundProperty = boundProperty;
		changeSupport.firePropertyChange("boundProperty", old, boundProperty);
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		changeSupport.addPropertyChangeListener(listener);
	}
	
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		changeSupport.removePropertyChangeListener(listener);
	}
	
	public boolean isBoundProperty() {
		return boundProperty;
	}

}
